/* Rating System */
function updateRating(id, score) {
    var pars = 'rating=' + score + '&id=' + id;
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/rating.php",
        data: pars,
        success: function (msg) {
            $(".star_rating").fadeOut().html(msg).fadeIn();
        }
    });
} 
/* Voting System */
function updateVoteUp(id) {
    var the_id = $('#vote_up-' + id).attr('value');
    $("span#votes_count" + id).fadeOut("fast");
    var pars = 'voting=1&action=vote_up' + '&id=' + id;
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/rating.php",
        data: pars,
        success: function (msg) {
            $("span#votes_count" + id).html(msg).fadeIn();
            $("span#vote_buttons" + id).remove();
        }
    });
}

function updateVoteDown(id) {
    var the_id = $('#vote_down-' + id).attr('value');
    var pars = 'action=vote_down' + '&id=' + id;
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/rating.php",
        data: pars,
        success: function (msg) {
            $("span#votes_count" + id).fadeOut().html(msg).fadeIn();
            $("span#vote_buttons" + id).remove();
        }
    });
}
/* Load Cart Items */
function loadCartSmall() {
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/load-cart.php",
        data: 'cartsmall=1',
        cache: false,
        success: function (html) {
            $("span.cart-status").html(html);
        }
    });
}
/* Load Cart Items */
function loadCartBig() {
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/load-cart.php",
        data: 'cartbig=1',
        cache: false,
        success: function (html) {
            $("div.show-cart-content").html(html);
        }
    });
}
/* Load Checkout */
function loadCheckout() {
    $.ajax({
        type: "POST",
        url: SITEURL + "/ajax/load-cart.php",
        data: 'checkout=1',
        cache: false,
        success: function (html) {
            $("div#process-checkout").html(html);
        }
    });
}
/* Live Search */
function lookup(inputString) {
	if (inputString.length == 0) {
		$('#suggestions').fadeOut();
	} else if(inputString.length > 3) {
		$.post(SITEURL + "/ajax/search.php", {
			liveSearch: "" + inputString
		}, 
		function (data) {
			$('#suggestions').fadeIn(200);
			$('#suggestions').html(data);
			 
		});
		$("input").blur(function () {
			$('#suggestions').fadeOut(200);
		});
	}
}

$(document).ready(function () {
	/* Rating Stars */
    $("[id^=rating_]").live("hover", function () {
        rid = $(this).attr("id").split("_")[1];
        $("#rating_" + rid).children("[class^=star_]").children('img').hover(function () {
            $("#rating_" + rid).children("[class^=star_]").children('img').removeClass("votehover");

            var hovered = $(this).parent().attr("class").split("_")[1];
            while (hovered > 0) {
                $("#rating_" + rid).children(".star_" + hovered).children('img').addClass("votehover");
                hovered--;
            }

        });
    });
    
	/* Verify Coupon Code */
	$("#verify-code").live("click", function () {
	    $.ajax({
	        type: "POST",
	        url: SITEURL + "/ajax/coupon.php",
	        data: 'coupon=' + $('#discount').val(),
	        success: function (msg) {
	            $("#totaldiscount").html(msg);
	            $(loadCheckout()).fadeIn("slow");
				setTimeout(function () {
	                $(loadCartSmall()).fadeIn("slow");
	            }, 2500);
	        }
	    });
	});

	/* Delete Checkout Items */
    $(".del-cart-full").live("click", function () {
        var parent = $(this).parent().parent()
        $.ajax({
            type: 'POST',
            url: SITEURL + "/ajax/load-cart.php",
            data: 'delcart=' + $(this).attr('id').replace('item_', ''),
            beforeSend: function () {
                parent.animate({
                    'backgroundColor': '#FFBFBF'
                }, 400);
            },
            success: function () {
                parent.fadeOut(400, function () {
                    parent.remove();
                    loadCartSmall();
                    setTimeout(function () {
                        $(loadCheckout());
                    }, 2500);
                });
            }
        });
        return false;
    });

	/* Single add to cart */
    $("a.add-to-cart").live("click", function () {
        var parent = $(this);
        var id = parent.attr('id').replace('item_', '');
        $.ajax({
            type: "POST",
            url: SITEURL + "/ajax/add-tocart.php",
            data: 'addtocart=' + $(this).attr('id').replace('item_', ''),

            beforeSend: function () {
                $('#list_' + id).animate({
                    opacity: 0.2
                }, 1000);
            },
            success: function () {
                $('#list_' + id).animate({
                    opacity: 1
                }, 1000);
                loadCartBig();
                setTimeout(function () {
                    $(loadCartSmall()).fadeIn("slow");
                }, 2500);
            }
        });
        return false;
    });

	/* Single Delete Cart */
    $(".del-cart").live("click", function () {
        var parent = $(this).parent()
        $.ajax({
            type: 'POST',
            url: SITEURL + "/ajax/load-cart.php",
            data: 'delcart=' + $(this).attr('id').replace('delid_', ''),
            beforeSend: function () {
                parent.animate({
                    'backgroundColor': '#FFBFBF'
                }, 400);
            },
            success: function () {
                parent.fadeOut(400, function () {
                    parent.remove();
                    loadCartSmall();
                    setTimeout(function () {
                        $(loadCartBig());
                    }, 2500);
                });
            }
        });
        return false;
    });
});